package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.DatosEnvioPostal;
import com.ejie.ab04b.model.DocumentoOS3;
import com.ejie.ab04b.model.TareaOS3;
import com.ejie.ab04b.model.TipoDocumento;
import com.ejie.ab04b.model.TramiteOS3;
import com.ejie.ab04b.util.DaoUtils;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0497s00DaoImpl generated by UDA, 05-Apr-2017 09:34:34.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class DocumentoOS3DaoImpl implements DocumentoOS3Dao {

	private static final String QUERY_SELECT = "SELECT t1.ID_DOCUMENTO_097 IDDOCUMENTO097, t1.ORIGEN_097 ORIGEN097, t1.FECHA_DOC_097 FECHADOC097, t1.RUTA_PIF_097 RUTAPIF097, t1.NOMBRE_DOC_097 NOMBREDOC097, t1.OID_DOKUSI_097 OIDDOKUSI097, t1.ID_TIPO_DOC_097 IDTIPODOC097, t1.ID_DATOS_ENVIO_POSTAL_097 IDDATOSENVIOPOSTAL097, t1.FORMATO_APORT_097 FORMATOAPORT097, t1.ID_TAREA_CONT_097 IDTAREACONT097, t1.ID_TRAMITE_OS3_097 IDTRAMITE097 FROM AB0497S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/**
	 * Gets the jdbc template.
	 * 
	 *  JdbcTemplate
	 *
	 * @return the jdbc template
	 */
	public JdbcTemplate getJdbcTemplate() {
		return this.jdbcTemplate;
	}

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DocumentoOS3> rwMap = new RowMapper<DocumentoOS3>() {
		public DocumentoOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			DocumentoOS3 documento = new DocumentoOS3(
					resultSet.getLong("IDDOCUMENTO097"),
					resultSet.getInt("ORIGEN097"),
					resultSet.getDate("FECHADOC097"),
					resultSet.getString("RUTAPIF097"),
					resultSet.getString("NOMBREDOC097"),
					resultSet.getString("OIDDOKUSI097"),
					new TipoDocumento(resultSet.getLong("IDTIPODOC097")), null,
					resultSet.getString("FORMATOAPORT097"), null,
					new TramiteOS3(resultSet.getLong("IDTRAMITE097")));

			Long idTareaContinuar = DaoUtils.getInstance()
					.getLongNullable(resultSet, "IDTAREACONT097");
			if (idTareaContinuar != null) {
				documento.setTareaOS3Continuar(new TareaOS3(idTareaContinuar));
			}

			Long idDatosEnvioPostal = DaoUtils.getInstance()
					.getLongNullable(resultSet, "IDDATOSENVIOPOSTAL097");
			if (idTareaContinuar != null) {
				documento.setDatosEnvioPostal(
						new DatosEnvioPostal(idDatosEnvioPostal));
			}

			return documento;
		}
	};

	private RowMapper<DocumentoOS3> rwMapPK = new RowMapper<DocumentoOS3>() {
		public DocumentoOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DocumentoOS3(resultSet.getLong("IDDOCUMENTO097"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0497s00 table.
	 * 
	 *  ab0497s00
	 *            Ab0497s00
	 *  Ab0497s00
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @return the documento OS 3
	 */
	public DocumentoOS3 add(DocumentoOS3 ab0497s00) {
		String query = "INSERT INTO AB0497S00 (ID_DOCUMENTO_097, ID_TAREA_CONT_097, ID_TRAMITE_OS3_097, ORIGEN_097, FECHA_DOC_097, RUTA_PIF_097, NOMBRE_DOC_097, OID_DOKUSI_097, ID_TIPO_DOC_097, ID_DATOS_ENVIO_POSTAL_097, FORMATO_APORT_097) VALUES (?,?,?,?,?,?,?,?,?,?,?)";

		// Obtenemos la secuencia
		ab0497s00.setIdDocumento097(
				Secuencias.DOC_OS3.getNextLong(jdbcTemplate));

		Long idTareaCont = null;
		if (ab0497s00.getTareaOS3Continuar() != null) {
			idTareaCont = ab0497s00.getTareaOS3Continuar().getIdTarea096();
		}

		Long idDatosEnvioPostal = null;
		if (ab0497s00.getDatosEnvioPostal() != null) {
			idTareaCont = ab0497s00.getDatosEnvioPostal()
					.getIdDatosEnvioPostal069();
		}
		Long idTipoDoc = null;
		if (ab0497s00.getTipoDocumento() != null) {
			idTipoDoc = ab0497s00.getTipoDocumento().getIdTipoDoc091();
		}
		this.jdbcTemplate.update(query, ab0497s00.getIdDocumento097(),
				idTareaCont, ab0497s00.getTramiteOS3().getIdTramite095(),
				ab0497s00.getOrigen097(), ab0497s00.getFechaDoc097(),
				ab0497s00.getRutaPif097(), ab0497s00.getNombreDoc097(),
				ab0497s00.getOidDokusi097(), idTipoDoc, idDatosEnvioPostal,
				ab0497s00.getFormatoAport097());
		return ab0497s00;
	}

	/**
	 * Updates a single row in the Ab0497s00 table.
	 * 
	 *  ab0497s00
	 *            Ab0497s00
	 *  Ab0497s00
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @return the documento OS 3
	 */
	public DocumentoOS3 update(DocumentoOS3 ab0497s00) {
		String query = "UPDATE AB0497S00 SET ID_TAREA_CONT_097=?, ID_TRAMITE_OS3_097=?, ORIGEN_097=?, FECHA_DOC_097=?, RUTA_PIF_097=?, NOMBRE_DOC_097=?, OID_DOKUSI_097=?, ID_TIPO_DOC_097=?, ID_DATOS_ENVIO_POSTAL_097=?, FORMATO_APORT_097=? WHERE ID_DOCUMENTO_097=?";

		Long idTareaCont = null;
		if (ab0497s00.getTareaOS3Continuar() != null) {
			idTareaCont = ab0497s00.getTareaOS3Continuar().getIdTarea096();
		}

		Long idDatosEnvioPostal = null;
		if (ab0497s00.getDatosEnvioPostal() != null) {
			idTareaCont = ab0497s00.getDatosEnvioPostal()
					.getIdDatosEnvioPostal069();
		}

		this.jdbcTemplate.update(query, idTareaCont,
				ab0497s00.getTramiteOS3().getIdTramite095(),
				ab0497s00.getOrigen097(), ab0497s00.getFechaDoc097(),
				ab0497s00.getRutaPif097(), ab0497s00.getNombreDoc097(),
				ab0497s00.getOidDokusi097(),
				ab0497s00.getTipoDocumento().getIdTipoDoc091(),
				idDatosEnvioPostal, ab0497s00.getFormatoAport097(),
				ab0497s00.getIdDocumento097());
		return ab0497s00;
	}

	/**
	 * Finds a single row in the Ab0497s00 table.
	 * 
	 *  ab0497s00
	 *            Ab0497s00
	 *  Ab0497s00
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @return the documento OS 3
	 */
	@Transactional(readOnly = true)
	public DocumentoOS3 find(DocumentoOS3 ab0497s00) {
		StringBuilder query = new StringBuilder(
				DocumentoOS3DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_DOCUMENTO_097 = ? ");

		List<DocumentoOS3> ab0497s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap, ab0497s00.getIdDocumento097());
		return (DocumentoOS3) DataAccessUtils.uniqueResult(ab0497s00List);
	}

	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 *  oid
	 *            String
	 *  DocumentoOS3
	 *
	 * @param oid the oid
	 * @return the documento OS 3
	 */
	@Transactional(readOnly = true)
	public DocumentoOS3 findByOid(String oid) {
		StringBuilder query = new StringBuilder(
				DocumentoOS3DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.OID_DOKUSI_097 = ? ");

		List<DocumentoOS3> ab0497s00List = this.jdbcTemplate
				.query(query.toString(), this.rwMap, oid);
		return (DocumentoOS3) DataAccessUtils.uniqueResult(ab0497s00List);
	}

	/**
	 * Removes a single row in the Ab0497s00 table.
	 * 
	 *  ab0497s00            Ab0497s00
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 */
	public void remove(DocumentoOS3 ab0497s00) {
		String query = "DELETE FROM AB0497S00 WHERE ID_DOCUMENTO_097=?";
		this.jdbcTemplate.update(query, ab0497s00.getIdDocumento097());
	}

	/**
	 * Finds a list of rows in the Ab0497s00 table.
	 * 
	 *  ab0497s00
	 *            Ab0497s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0497s00>
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS3> findAll(DocumentoOS3 ab0497s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DocumentoOS3DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0497s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0497s00 table using like.
	 * 
	 *  ab0497s00
	 *            Ab0497s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0497s00>
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS3> findAllLike(DocumentoOS3 ab0497s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DocumentoOS3DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0497s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0497s00 table.
	 * 
	 *  ab0497s00
	 *            Ab0497s00
	 *  Long
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DocumentoOS3 ab0497s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0497S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0497s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0497s00 table using like.
	 * 
	 *  ab0497s00
	 *            Ab0497s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DocumentoOS3 ab0497s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0497S00 t1");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0497s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0497s00 selected for rup_table.
	 * 
	 *  ab0497s00            Ab0497s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0497s00>>
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DocumentoOS3>> reorderSelection(
			DocumentoOS3 ab0497s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				DocumentoOS3DaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0497s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, DocumentoOS3.class, filterParamList,
				"ID_DOCUMENTO_097");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoOS3>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0497s00
	 *  searchParams            Ab0497s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0497s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DocumentoOS3>> search(DocumentoOS3 filterParams,
			DocumentoOS3 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				DocumentoOS3DaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, DocumentoOS3.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_DOCUMENTO_097");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<DocumentoOS3>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0497s00 entity.
	 * 
	 *  ab0497s00            Ab0497s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DocumentoOS3 ab0497s00) {

		StringBuilder where = new StringBuilder(
				DocumentoOS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0497s00 != null && ab0497s00.getIdDocumento097() != null) {
			where.append(" AND t1.ID_DOCUMENTO_097 = ?");
			params.add(ab0497s00.getIdDocumento097());
		}
		if (ab0497s00 != null && ab0497s00.getTareaOS3Continuar() != null
				&& ab0497s00.getTareaOS3Continuar().getIdTarea096() != null) {
			where.append(" AND t1.ID_TAREA_CONT_097 = ?");
			params.add(ab0497s00.getTareaOS3Continuar().getIdTarea096());
		}
		if (ab0497s00 != null && ab0497s00.getTramiteOS3() != null
				&& ab0497s00.getTramiteOS3().getIdTramite095() != null) {
			where.append(" AND t1.ID_TRAMITE_OS3_097 = ?");
			params.add(ab0497s00.getTramiteOS3().getIdTramite095());
		}
		if (ab0497s00 != null && ab0497s00.getOrigen097() != null) {
			where.append(" AND t1.ORIGEN_097 = ?");
			params.add(ab0497s00.getOrigen097());
		}
		if (ab0497s00 != null && ab0497s00.getFechaDoc097() != null) {
			where.append(" AND t1.FECHA_DOC_097 = ?");
			params.add(ab0497s00.getFechaDoc097());
		}
		if (ab0497s00 != null && ab0497s00.getRutaPif097() != null) {
			where.append(" AND t1.RUTA_PIF_097 = ?");
			params.add(ab0497s00.getRutaPif097());
		}
		if (ab0497s00 != null && ab0497s00.getNombreDoc097() != null) {
			where.append(" AND t1.NOMBRE_DOC_097 = ?");
			params.add(ab0497s00.getNombreDoc097());
		}
		if (ab0497s00 != null && ab0497s00.getOidDokusi097() != null) {
			where.append(" AND t1.OID_DOKUSI_097 = ?");
			params.add(ab0497s00.getOidDokusi097());
		}
		if (ab0497s00 != null && ab0497s00.getTipoDocumento() != null
				&& ab0497s00.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_097 = ?");
			params.add(ab0497s00.getTipoDocumento().getIdTipoDoc091());
		}
		if (ab0497s00 != null && ab0497s00.getDatosEnvioPostal() != null
				&& ab0497s00.getDatosEnvioPostal()
						.getIdDatosEnvioPostal069() != null) {
			where.append(" AND t1.ID_DATOS_ENVIO_POSTAL_097 = ?");
			params.add(
					ab0497s00.getDatosEnvioPostal().getIdDatosEnvioPostal069());
		}
		if (ab0497s00 != null && ab0497s00.getFormatoAport097() != null) {
			where.append(" AND t1.FORMATO_APORT_097 = ?");
			params.add(ab0497s00.getFormatoAport097());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0497s00 entity.
	 * 
	 *  ab0497s00            Ab0497s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(DocumentoOS3 ab0497s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DocumentoOS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0497s00 != null && ab0497s00.getIdDocumento097() != null) {
			where.append(" AND t1.ID_DOCUMENTO_097 = ?");
			params.add(ab0497s00.getIdDocumento097());
		}
		if (ab0497s00 != null && ab0497s00.getTareaOS3Continuar() != null
				&& ab0497s00.getTareaOS3Continuar().getIdTarea096() != null) {
			where.append(" AND t1.ID_TAREA_CONT_097 = ?");
			params.add(ab0497s00.getTareaOS3Continuar().getIdTarea096());
		}
		if (ab0497s00 != null && ab0497s00.getTramiteOS3() != null
				&& ab0497s00.getTramiteOS3().getIdTramite095() != null) {
			where.append(" AND t1.ID_TRAMITE_OS3_097 = ?");
			params.add(ab0497s00.getTramiteOS3().getIdTramite095());
		}
		if (ab0497s00 != null && ab0497s00.getOrigen097() != null) {
			where.append(" AND t1.ORIGEN_097 = ?");
			params.add(ab0497s00.getOrigen097());
		}
		if (ab0497s00 != null && ab0497s00.getFechaDoc097() != null) {
			where.append(" AND t1.FECHA_DOC_097 = ?");
			params.add(ab0497s00.getFechaDoc097());
		}
		if (ab0497s00 != null && ab0497s00.getRutaPif097() != null) {
			where.append(" AND UPPER(t1.RUTA_PIF_097) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0497s00.getRutaPif097().toUpperCase() + "%");
			} else {
				params.add("%" + ab0497s00.getRutaPif097().toUpperCase() + "%");
			}
			where.append(" AND t1.RUTA_PIF_097 IS NOT NULL");
		}
		if (ab0497s00 != null && ab0497s00.getNombreDoc097() != null) {
			where.append(" AND UPPER(t1.NOMBRE_DOC_097) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0497s00.getNombreDoc097().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0497s00.getNombreDoc097().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE_DOC_097 IS NOT NULL");
		}
		if (ab0497s00 != null && ab0497s00.getOidDokusi097() != null) {
			where.append(" AND UPPER(t1.OID_DOKUSI_097) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0497s00.getOidDokusi097().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0497s00.getOidDokusi097().toUpperCase() + "%");
			}
			where.append(" AND t1.OID_DOKUSI_097 IS NOT NULL");
		}
		if (ab0497s00 != null && ab0497s00.getTipoDocumento() != null
				&& ab0497s00.getTipoDocumento().getIdTipoDoc091() != null) {
			where.append(" AND t1.ID_TIPO_DOC_097 = ?");
			params.add(ab0497s00.getTipoDocumento().getIdTipoDoc091());
		}
		if (ab0497s00 != null && ab0497s00.getDatosEnvioPostal() != null
				&& ab0497s00.getDatosEnvioPostal()
						.getIdDatosEnvioPostal069() != null) {
			where.append(" AND t1.ID_DATOS_ENVIO_POSTAL_097 = ?");
			params.add(
					ab0497s00.getDatosEnvioPostal().getIdDatosEnvioPostal069());
		}
		if (ab0497s00 != null && ab0497s00.getFormatoAport097() != null) {
			where.append(
					" AND UPPER(t1.FORMATO_APORT_097) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0497s00.getFormatoAport097().toUpperCase() + "%");
			} else {
				params.add("%" + ab0497s00.getFormatoAport097().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.FORMATO_APORT_097 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	/**
	 * Updates a single row in the Expedientes table.
	 * 
	 *  ab0497s00
	 *            DocumentoOS3
	 *  DocumentoOS3
	 *
	 * @param ab0497s00 the ab 0497 s 00
	 * @return the documento OS 3
	 */
	public DocumentoOS3 updateFilled(DocumentoOS3 ab0497s00) {
		StringBuilder query = new StringBuilder("UPDATE AB0497S00 SET ");

		List<Object> params = new ArrayList<Object>();
		StringBuilder queryFields = new StringBuilder();

		if (ab0497s00 != null) {

			if (ab0497s00.getTareaOS3Continuar() != null && ab0497s00
					.getTareaOS3Continuar().getIdTarea096() != null) {
				queryFields.append(", ID_TAREA_CONT_097 = ? ");
				params.add(ab0497s00.getTareaOS3Continuar().getIdTarea096());
			}
			if (ab0497s00.getNombreDoc097() != null) {
				queryFields.append(", NOMBRE_DOC_097 = ? ");
				params.add(ab0497s00.getNombreDoc097());
			}
			if (ab0497s00.getOidDokusi097() != null) {
				queryFields.append(", OID_DOKUSI_097 = ? ");
				params.add(ab0497s00.getOidDokusi097());
			}
			if (ab0497s00.getDatosEnvioPostal() != null && ab0497s00
					.getDatosEnvioPostal().getIdDatosEnvioPostal069() != null) {
				queryFields.append(", ID_DATOS_ENVIO_POSTAL_097 = ? ");
				params.add(ab0497s00.getDatosEnvioPostal()
						.getIdDatosEnvioPostal069());
			}

			if (queryFields.length() > 0) {
				queryFields.deleteCharAt(0);
			}
		}

		query.append(queryFields);
		query.append(" WHERE ID_DOCUMENTO_097 = ?");

		params.add(ab0497s00.getIdDocumento097());

		this.jdbcTemplate.update(query.toString(), params.toArray());
		return ab0497s00;
	}

	/**
	 * Finds a list of rows in the SolicDocumentos table.
	 * 
	 *  solicdocumentos
	 *            DocumentoOS3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<SolicDocumentos>
	 *
	 * @param solicdocumentos the solicdocumentos
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DocumentoOS3> buscarPorIdTramiteYMetadatoNombre(
			DocumentoOS3 solicdocumentos, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DocumentoOS3DaoImpl.QUERY_SELECT);
		query.append(
				" WHERE t1.ID_TRAMITE_OS3_097 = ? AND UPPER(SUBSTR(t1.NOMBRE_DOC_097, 1, INSTR(t1.NOMBRE_DOC_097, '.', -1) - 1)) = ? ");
		// El metadato object_name nos devuelve el nombre del fichero en
		// minúsculas y sin extensión
		// Buscamos ese nombre en mayúsculas descartando lo que haya en BD a
		// partir del último punto

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DocumentoOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, solicdocumentos.getTramiteOS3().getIdTramite095(),
				solicdocumentos.getNombreDoc097().toUpperCase());
	}

	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 *  doc the doc
	 *  DocumentoAperturas
	 *
	 * @param doc the doc
	 * @return the documento OS 3
	 */
	@Transactional(readOnly = true)
	public DocumentoOS3 findByTramite(DocumentoOS3 doc) {
		StringBuilder query = new StringBuilder(
				DocumentoOS3DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(doc);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		List<DocumentoOS3> docList = this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());

		return (DocumentoOS3) DataAccessUtils.uniqueResult(docList);
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
